IF EXISTS (SELECT * FROM SYS.VIEWS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[V_APURA_ICMS_ST]'))
	DROP VIEW V_APURA_ICMS_ST
GO
/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 2202031702 
'Job.................:  
'Nome................: CTB_APURA_ICMS_ST 
'Objetivo............:  
'Tabelas.............: CTB_APURA_ICMS_ST
'Dt Criao..........: 
'Dt Ult Alteraco....: 25/11/2021
'Alterado por........: Marcos Barros 
'Criado por..........: Shirlene 
'=======================================================================================
FARMAGOI-23644 - SELECT * FROM V_APURA_ICMS_ST WHERE CD_FILIAL = 1  AND MES = 7 AND ANO = 2021 - Marcos Barros 
CLOUDFARMA-1971 - 2202031702 - adicionado tratativa COLLATE DATABASE_DEFAULT - Marcos Barros 
*/
CREATE VIEW V_APURA_ICMS_ST
WITH ENCRYPTION
AS 
SELECT
	CD_EMP					AS CD_EMP, 
	DT_DOC 					AS DT_DOC, 
	MES						AS MES, 
	ANO						AS ANO, 
	CD_FILIAL				AS CD_FILIAL,
    UF COLLATE DATABASE_DEFAULT						AS UF ,
    SUM(VL_SLD_CRED_ANT)	AS VLR_SLD_CRED_ANT,
    SUM(VLR_DEVOLUCAO)		AS VLR_DEVOLUCAO,
    SUM(VLR_RESSARC)		AS VLR_RESSARC,
    SUM(VLR_OUTR_CRED)		AS VLR_OUTR_CRED,
    SUM(VLR_AJUSTE_CRED)	AS VLR_AJUSTE_CRED,
    SUM(VLR_RETENCAO)		AS VLR_RETENCAO,
    SUM(VLR_OUT_DEB)		AS VLR_OUT_DEB,
    SUM(VLR_AJUST_DEB)		AS VLR_AJUST_DEB,
    SUM(VLR_DEDUCOES)		AS VLR_DEDUCOES 
FROM  ( 
/***************************************************************************************
	VL_DEVOL_ST 
****************************************************************************************/  
		SELECT   
			V_EST_NF_ENT.CD_EMP		AS CD_EMP,
		   V_EST_NF_ENT.CD_FILIAL	AS CD_FILIAL,
			UF_DESTINATARIO  COLLATE DATABASE_DEFAULT				AS UF,
			V_EST_NF_ENT.DT_ENT		AS DT_DOC,
			MONTH(DT_ENT)			AS ANO ,
			MONTH(DT_ENT)			AS MES,
			0						AS VL_SLD_CRED_ANT,
			SUM(VLR_ICMS_SUBS_IT)	AS VLR_DEVOLUCAO,
			0						AS VLR_RESSARC,
			0						AS VLR_OUTR_CRED ,
			0						AS VLR_AJUSTE_CRED,
			0						AS VLR_RETENCAO ,
			0						AS VLR_OUT_DEB , 
			0						AS VLR_AJUST_DEB,
			0						AS VLR_DEDUCOES
		  FROM     
			V_EST_NF_ENT 
		     INNER JOIN PRC_FILIAL ON       
						V_EST_NF_ENT.CD_EMP    = PRC_FILIAL.CD_EMP
		           AND V_EST_NF_ENT.CD_FILIAL = PRC_FILIAL.CD_FILIAL
		  WHERE    
				V_EST_NF_ENT.STS_NF	= 0
			AND V_EST_NF_ENT.TP_MOV = 11 
			AND VLR_ICMS_SUBS_IT > 0
			--AND V_EST_NF_ENT.CD_EMP   = 1 
			--AND V_EST_NF_ENT.CD_FILIAL IN (37)
			--AND V_EST_NF_ENT.DT_ENT BETWEEN '07/01/2021' AND      '07/31/2021' 
		   AND	NOT EXISTS( 
				SELECT 
					CD_EMP
		        FROM    
					CTB_APURA_ICMS_ST
		        WHERE   
					CTB_APURA_ICMS_ST.CD_EMP			= V_EST_NF_ENT.CD_EMP
		           AND CTB_APURA_ICMS_ST.CD_FILIAL		= V_EST_NF_ENT.CD_FILIAL
		           AND CTB_APURA_ICMS_ST.MES_APURAC	= MONTH(DT_ENT)
		           AND CTB_APURA_ICMS_ST.ANO_APURAC	= MONTH(DT_ENT)
					AND CTB_APURA_ICMS_ST.UF COLLATE DATABASE_DEFAULT			= V_EST_NF_ENT.UF_DESTINATARIO COLLATE DATABASE_DEFAULT
		        )
		    GROUP BY 
				V_EST_NF_ENT.CD_FILIAL , UF_DESTINATARIO  COLLATE DATABASE_DEFAULT	  ,V_EST_NF_ENT.DT_ENT , V_EST_NF_ENT.CD_EMP             
		    
         UNION ALL
/***************************************************************************************
	VL_RESSARC_ST 
****************************************************************************************/ 
         SELECT  
			V_EST_NF_ENT.CD_EMP		AS CD_EMP,
			V_EST_NF_ENT.CD_FILIAL	AS CD_FILIAL,
			UF_DESTINATARIO	 COLLATE DATABASE_DEFAULT			AS UF,
			V_EST_NF_ENT.DT_ENT		AS DT_DOC,
			YEAR(DT_ENT)			AS ANO,
			MONTH(DT_ENT)			AS MES,
			0						AS VL_SLD_CRED_ANT,
			0						AS VLR_DEVOLUCAO,
			SUM(VLR_ICMS_SUBS_IT)	AS VLR_RESSARC,
			0						AS VLR_OUTR_CRED ,
			0						AS VLR_AJUSTE_CRED,
			0						AS VLR_RETENCAO ,
			0						AS VLR_OUT_DEB , 
			0						AS VLR_AJUST_DEB,
			0						AS VLR_DEDUCOES
         FROM     
			V_EST_NF_ENT 
			INNER JOIN PRC_FILIAL ON
					V_EST_NF_ENT.CD_EMP    = PRC_FILIAL.CD_EMP
				AND V_EST_NF_ENT.CD_FILIAL = PRC_FILIAL.CD_FILIAL
         WHERE		
				V_EST_NF_ENT.STS_NF = 0
			AND	V_EST_NF_ENT.CFOP in ('1603' , '2603')
			AND	VLR_ICMS_SUBS_IT > 0
			--AND  V_EST_NF_ENT.CD_EMP   = 1 
			--AND	V_EST_NF_ENT.CD_FILIAL IN (37)
			--AND	V_EST_NF_ENT.DT_ENT BETWEEN '07/01/2021' AND      '07/31/2021'
            AND NOT EXISTS( 
				SELECT 
					CD_EMP
                FROM    
					CTB_APURA_ICMS_ST
                WHERE   
						CTB_APURA_ICMS_ST.CD_EMP		= V_EST_NF_ENT.CD_EMP
					AND CTB_APURA_ICMS_ST.CD_FILIAL		= V_EST_NF_ENT.CD_FILIAL
					AND CTB_APURA_ICMS_ST.MES_APURAC	= MONTH(DT_ENT)
					AND CTB_APURA_ICMS_ST.ANO_APURAC	= YEAR(DT_ENT)
					AND CTB_APURA_ICMS_ST.UF COLLATE DATABASE_DEFAULT			= V_EST_NF_ENT.UF_DESTINATARIO COLLATE DATABASE_DEFAULT
                  )
         GROUP BY 
			V_EST_NF_ENT.CD_FILIAL, UF_DESTINATARIO  COLLATE DATABASE_DEFAULT	, V_EST_NF_ENT.DT_ENT,  V_EST_NF_ENT.CD_EMP

        UNION ALL
/***************************************************************************************
	VL_OUT_CRED_ST
****************************************************************************************/  
	  SELECT  
		AJUSTES.CD_EMP		AS CD_EMP, 
		AJUSTES.CD_FILIAL	AS CD_FILIAL, 
		UF		 COLLATE DATABASE_DEFAULT				AS UF, 
		AJUSTES.DT_CAD		AS DT_DOC,
		ANO					AS ANO,
		MES					AS MES,
		0					AS VL_SLD_CRED_ANT,
		0					AS VLR_DEVOLUCAO,
		0					AS VLR_RESSARC,
		SUM(VALOR)			AS VLR_OUTR_CRED,
		0					as VLR_AJUSTE_CRED ,
		0					AS VLR_RETENCAO ,
		0					AS VLR_OUT_DEB , 
		0					AS VLR_AJUST_DEB ,
		0					AS VLR_DEDUCOES 
	 FROM     
		CTB_APURA_ICMS_ST_AJUSTES AJUSTES
	 WHERE  
		TIPO = 2 
		AND NOT EXISTS( 
			SELECT 
				CD_EMP
            FROM    
				CTB_APURA_ICMS_ST
            WHERE
					CTB_APURA_ICMS_ST.CD_EMP		= AJUSTES.CD_EMP
				AND CTB_APURA_ICMS_ST.CD_FILIAL		= AJUSTES.CD_FILIAL
				AND CTB_APURA_ICMS_ST.MES_APURAC	= AJUSTES.MES
				AND CTB_APURA_ICMS_ST.ANO_APURAC	= AJUSTES.ANO
				AND CTB_APURA_ICMS_ST.UF COLLATE DATABASE_DEFAULT			= AJUSTES.UF COLLATE DATABASE_DEFAULT
             ) 
	 --AND AJUSTES.CD_EMP             = 1
	 --AND      AJUSTES.CD_FILIAL IN (37)
	 --AND      AJUSTES.MES = 7
	 --AND      AJUSTES.ANO = 2021
	 GROUP BY 
		UF  COLLATE DATABASE_DEFAULT	,AJUSTES.CD_FILIAL,TIPO,AJUSTES.CD_EMP,AJUSTES.DT_CAD,ANO,MES

	 UNION ALL
/***************************************************************************************
	VL_RETENAO_ST
****************************************************************************************/    
	SELECT   
		EST_NF_SAI.CD_EMP					AS CD_EMP, 
		EST_NF_SAI.CD_FILIAL				AS CD_FILIAL, 
		UF_DESTINATARIO	 COLLATE DATABASE_DEFAULT						AS UF ,
		EST_NF_SAI.DT_EMI_NF				AS DT_DOC,
		YEAR(EST_NF_SAI.DT_EMI_NF)			AS ANO ,
		MONTH(EST_NF_SAI.DT_EMI_NF)			AS MES,
        0									AS VL_SLD_CRED_ANT,
		0									AS VLR_DEVOLUCAO,
		0									AS VLR_RESSARC,
		0									AS VLR_OUTR_CRED ,
		0									AS VLR_AJUSTE_CRED,
        SUM(EST_NF_SAI_IT.VLR_ICMS_SUBS)	AS VLR_RETENCAO ,
		0									AS VLR_OUT_DEB , 
		0									AS VLR_AJUST_DEB,
		0									AS VLR_DEDUCOES
        FROM     
			EST_NF_SAI
            INNER JOIN EST_NF_SAI_IT ON       
					EST_NF_SAI.CD_EMP    = EST_NF_SAI_IT.CD_EMP
                AND EST_NF_SAI.CD_FILIAL = EST_NF_SAI_IT.CD_FILIAL
                AND EST_NF_SAI.CD_NF     = EST_NF_SAI_IT.CD_NF
            INNER JOIN EST_TRIB ON
					EST_NF_SAI_IT.CD_TRIB = EST_TRIB.CD_TRIB
            INNER JOIN PRC_FILIAL ON
					EST_NF_SAI.CD_EMP    = PRC_FILIAL.CD_EMP
				AND EST_NF_SAI.CD_FILIAL = PRC_FILIAL.CD_FILIAL
             LEFT OUTER JOIN PDV_VD_EST_NF_SAI ON
					EST_NF_SAI.CD_EMP    = PDV_VD_EST_NF_SAI.CD_EMP
                AND EST_NF_SAI.CD_FILIAL = PDV_VD_EST_NF_SAI.CD_FILIAL
                AND EST_NF_SAI.CD_NF     = PDV_VD_EST_NF_SAI.CD_NF
        WHERE    
			EST_NF_SAI.CD_EMP = 1
            AND EST_NF_SAI.STS_NF = 0
			AND EST_NF_SAI_IT.VLR_ICMS_SUBS > 0 
            AND PDV_VD_EST_NF_SAI.CD_NF IS NULL
            AND NOT EXISTS ( 
				SELECT 
					CD_EMP
                FROM    
					CTB_APURA_ICMS_ST
                WHERE   
						CTB_APURA_ICMS_ST.CD_EMP		= EST_NF_SAI.CD_EMP
					AND CTB_APURA_ICMS_ST.CD_FILIAL		= EST_NF_SAI.CD_FILIAL
					AND CTB_APURA_ICMS_ST.MES_APURAC	= MONTH(EST_NF_SAI.DT_EMI_NF) 
					AND CTB_APURA_ICMS_ST.ANO_APURAC	= YEAR(EST_NF_SAI.DT_EMI_NF)
					AND	CTB_APURA_ICMS_ST.UF COLLATE DATABASE_DEFAULT			= EST_NF_SAI.UF_DESTINATARIO COLLATE DATABASE_DEFAULT
                 )
			--AND      EST_NF_SAI.CD_FILIAL IN (11)
			--AND      EST_NF_SAI.DT_EMI_NF BETWEEN '08/01/2021'AND     '08/31/2021'
        GROUP BY 
			EST_NF_SAI.CD_FILIAL, EST_NF_SAI.CD_EMP,EST_NF_SAI.DT_EMI_NF, UF_DESTINATARIO  COLLATE DATABASE_DEFAULT	
        
     UNION ALL

/***************************************************************************************
	VL_OUT_DEB_ST
****************************************************************************************/
	 SELECT  
		AJUSTES.CD_EMP		AS CD_EMP,
		AJUSTES.CD_FILIAL	AS CD_FILIAL,
		UF	 COLLATE DATABASE_DEFAULT					AS UF,
	    AJUSTES.DT_CAD		AS DT_DOC,
		ANO					AS ANO,
		MES					AS MES,					     
		0					AS VL_SLD_CRED_ANT,
		0					AS VLR_DEVOLUCAO,
		0					AS VLR_RESSARC,
		0					AS VLR_OUTR_CRED,
		0					AS VLR_AJUSTE_CRED ,
		0					AS VLR_RETENCAO ,
		SUM(VALOR)			AS VLR_OUT_DEB , 
		0					AS VLR_AJUST_DEB,
		0					AS VLR_DEDUCOES
	 FROM     
		CTB_APURA_ICMS_ST_AJUSTES AJUSTES
	 WHERE   
		TIPO = 0  
		AND NOT EXISTS( 
			SELECT 
				CD_EMP
            FROM    
				CTB_APURA_ICMS_ST
            WHERE   
					CTB_APURA_ICMS_ST.CD_EMP     = AJUSTES.CD_EMP
				AND CTB_APURA_ICMS_ST.CD_FILIAL  = AJUSTES.CD_FILIAL
                AND CTB_APURA_ICMS_ST.MES_APURAC = AJUSTES.MES
                AND CTB_APURA_ICMS_ST.ANO_APURAC = AJUSTES.ANO
				AND CTB_APURA_ICMS_ST.UF COLLATE DATABASE_DEFAULT		 = AJUSTES.UF COLLATE DATABASE_DEFAULT
          )
	 --AND      AJUSTES.CD_EMP   = 1
	 --AND      AJUSTES.CD_FILIAL IN (37)
	 --AND      AJUSTES.MES = 7
	 --AND      AJUSTES.ANO = 2021
	 GROUP BY 
		UF  COLLATE DATABASE_DEFAULT	,AJUSTES.CD_FILIAL,TIPO ,AJUSTES.DT_CAD ,AJUSTES.CD_EMP,ANO,MES 

	UNION ALL

/***************************************************************************************
	VL_DEDUES_ST
****************************************************************************************/
	SELECT  
		AJUSTES.CD_EMP		AS CD_EMP,
		AJUSTES.CD_FILIAL	AS CD_FILIAL,
		UF	 COLLATE DATABASE_DEFAULT					AS UF,
	    AJUSTES.DT_CAD		AS DT_DOC,
		ANO					AS ANO,
		MES					AS MES,					     
		0					AS VL_SLD_CRED_ANT,
		0					AS VLR_DEVOLUCAO,
		0					AS VLR_RESSARC,
		0					AS VLR_OUTR_CRED,
		0					AS VLR_AJUSTE_CRED ,
		0					AS VLR_RETENCAO ,
		0					AS VLR_OUT_DEB , 
		0					AS VLR_AJUST_DEB,
		SUM(VALOR)			AS VLR_DEDUCOES
	 FROM     
		CTB_APURA_ICMS_ST_AJUSTES AJUSTES
	 
	 WHERE   
		TIPO = 1
	    AND NOT EXISTS( 
			SELECT 
				CD_EMP
            FROM    
				CTB_APURA_ICMS_ST
            WHERE   
					CTB_APURA_ICMS_ST.CD_EMP     = AJUSTES.CD_EMP
                AND CTB_APURA_ICMS_ST.CD_FILIAL  = AJUSTES.CD_FILIAL
                AND CTB_APURA_ICMS_ST.MES_APURAC = AJUSTES.MES
                AND CTB_APURA_ICMS_ST.ANO_APURAC = AJUSTES.ANO
				AND CTB_APURA_ICMS_ST.UF COLLATE DATABASE_DEFAULT		 = AJUSTES.UF COLLATE DATABASE_DEFAULT
                 )
	 --AND	AJUSTES.CD_EMP   = 1
	 --AND  AJUSTES.CD_FILIAL IN (37)
	 --AND  AJUSTES.MES = 7
	 --AND  AJUSTES.ANO = 2021
	 GROUP BY 
		UF  COLLATE DATABASE_DEFAULT	,AJUSTES.CD_FILIAL,TIPO ,AJUSTES.DT_CAD ,AJUSTES.CD_EMP,ANO,MES  
) TEMP
GROUP BY CD_FILIAL ,CD_EMP, DT_DOC, UF  , MES, ANO
         





	 